(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     89953,       2319]
NotebookOptionsPosition[     87818,       2280]
NotebookOutlinePosition[     88214,       2296]
CellTagsIndexPosition[     88171,       2293]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
A notebook with some functions to read and plot the FPLO basis radial \
functions.\
\>", "Text",
 CellChangeTimes->{{3.8737987238423433`*^9, 
  3.873798749553837*^9}},ExpressionUUID->"34455bfe-e148-4032-a329-\
18cf78fb01bd"],

Cell[TextData[{
 "We consider 3 cases, the non-relativistic case, the scalar-relativistic \
case and the full relativistic case. The non-relativistic case has a single \
basis function for each n and l. The full relativistic case has for each \
quantum number kappa (l s j) two basis functions. The large and small part of \
the wave function. The scalar relativistic case has for each quantum number n \
and l 4 wave functions. These are made from the full relativistic functions, \
but averaged over the j = l -1/2 and j = l+1/2 states. The scalar \
relativistic 4-vector is normalized. The components are\n ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", "l"}], "+", "2"}], 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "l"}], "+", "1"}], ")"}]}]], 
     SuperscriptBox["g", "+"]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "l"}], 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "l"}], "+", "1"}], ")"}]}]], 
     SuperscriptBox["g", "-"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "9f42a766-ccd7-40d5-b62d-62d2ec2a3f4a"],
 "\n ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", "l"}], "+", "2"}], 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "l"}], "+", "1"}], ")"}]}]], 
     SuperscriptBox["f", "+"]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "l"}], 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "l"}], "+", "1"}], ")"}]}]], 
     SuperscriptBox["f", "-"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "939307e8-ff5a-473b-958d-a6c14f458882"],
 "\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[Gamma]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["g", "-"], "-", 
      SuperscriptBox["g", "+"]}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d748d2b2-d320-40b2-872b-3e0dbe8804d0"],
 "\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[Gamma]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["f", "-"], "-", 
      SuperscriptBox["f", "+"]}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "fb49d33e-bd15-421f-957d-72d3845fc6dc"],
 "\n  with ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "g"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "35a30049-6848-4dbc-a144-a12557524d83"],
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "f"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "d6927696-8b7b-4cad-9695-8b50c9ee2db9"],
 "the large and small part of the full relativistic state with j = l -1/2 for \
the - states and j = l+1/2 for the + states."
}], "Text",
 CellChangeTimes->{{3.8737987238423433`*^9, 
  3.873799201103133*^9}},ExpressionUUID->"2ee9fdac-d463-494f-b81b-\
6c65a4093c3e"],

Cell[CellGroupData[{

Cell["Make strings better readable", "Subsection",
 CellChangeTimes->{{3.8737992271165648`*^9, 
  3.87379924425863*^9}},ExpressionUUID->"74fa43d3-9693-417e-9a63-\
c1496757a66b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NiceOrbRelativistic", "[", "b_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"NumberQ", "[", 
        RowBox[{"a", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"ToString", "[", 
         RowBox[{"a", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\<p\>\""}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "<>", 
     RowBox[{"StringDrop", "[", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.873798365860914*^9},ExpressionUUID->"e1abcb9a-a6d7-40f5-92d5-\
1ef5a78edebd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NiceOrbScalarRelativistic", "[", "b_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"StringDrop", "[", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"1728a30a-20be-4403-8117-2760f512e72d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NiceOrbScalarNonRelativistic", "[", "b_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"StringDrop", "[", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.873798430455769*^9, 
  3.873798445736333*^9}},ExpressionUUID->"80378ee1-26f2-4cf3-8186-\
3e4df9788747"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Read the files from disc", "Subsection",
 CellChangeTimes->{{3.8737992271165648`*^9, 
  3.8737992567757683`*^9}},ExpressionUUID->"6b22a6eb-2ae6-4b01-946e-\
89e9b0483a80"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadRadialFunctionsRelativistic", "[", "FileNames_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "position", ",", "BasisFun", ",", "Orbitals", ",", "BasisRawVal1", ",", 
      "BasisRawVal2", ",", "BasisVal1", ",", "BasisVal2", ",", "BasisVal1Fun",
       ",", "BasisVal2Fun", ",", "OrbitalsRawVal1", ",", "OrbitalsRawVal2", 
      ",", "\[IndentingNewLine]", "s12pos", ",", "p12pos", ",", "p32pos", ",",
       "d32pos", ",", "d52pos", ",", "f52pos", ",", "f72pos", ",", "g72pos", 
      ",", "g92pos"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"BasisRawVal1", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "filename", "<>", 
             "\"\<.1\>\""}], ",", "\"\<Table\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"filename", ",", "FileNames"}], "}"}]}], "]"}], ",", "1"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BasisRawVal2", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "filename", "<>", 
             "\"\<.2\>\""}], ",", "\"\<Table\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"filename", ",", "FileNames"}], "}"}]}], "]"}], ",", "1"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BasisVal1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BasisRawVal1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ";;", 
           RowBox[{"i", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<<start\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "+", 
              "1"}], ",", 
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<<end\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "-", 
              "1"}]}], "}"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal2", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BasisRawVal2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ";;", 
           RowBox[{"i", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<<start\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "+", 
              "1"}], ",", 
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<<end\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "-", 
              "1"}]}], "}"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal1Fun", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<Spline\>\""}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "BasisVal1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal2Fun", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<Spline\>\""}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "BasisVal2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisFun", "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"BasisVal1Fun", ",", "BasisVal2Fun"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"OrbitalsRawVal1", "=", 
      RowBox[{"NiceOrbRelativistic", "[", 
       RowBox[{
        RowBox[{"BasisRawVal1", "[", 
         RowBox[{"[", 
          RowBox[{"Intersection", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal1", ",", "\"\<<start\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "]"}], 
         "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{
           RowBox[{"-", "2"}], ";;", 
           RowBox[{"-", "1"}]}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"OrbitalsRawVal2", "=", 
      RowBox[{"NiceOrbRelativistic", "[", 
       RowBox[{
        RowBox[{"BasisRawVal2", "[", 
         RowBox[{"[", 
          RowBox[{"Intersection", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal2", ",", "\"\<<start\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal2", ",", "\"\<function\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "]"}], 
         "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{
           RowBox[{"-", "2"}], ";;", 
           RowBox[{"-", "1"}]}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Orbitals", "=", "OrbitalsRawVal1"}], ";", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{"s12pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<s1/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<s1/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<s1/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p12pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p1/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p1/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p1/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p32pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p3/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p3/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p3/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"d32pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d3/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d3/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d3/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"d52pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d5/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d5/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d5/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f52pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f5/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f5/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f5/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f72pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f7/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f7/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f7/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"g72pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g7/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g7/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g7/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"g92pos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g9/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g9/2\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "3"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g9/2\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"position", "[", "OrbitalName_", "]"}], ":=", 
      TagBox[GridBox[{
         {"\[Piecewise]", GridBox[{
            {"s12pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<s12\>\""}]},
            {"p12pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<p12\>\""}]},
            {"p32pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<p32\>\""}]},
            {"d32pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<d32\>\""}]},
            {"d52pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<d52\>\""}]},
            {"f52pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<f52\>\""}]},
            {"f72pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<f72\>\""}]},
            {"g72pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<g72\>\""}]},
            {"g92pos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<g92\>\""}]}
           },
           AllowedDimensions->{2, Automatic},
           Editable->True,
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.84]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           Selectable->True]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.35]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Piecewise",
       DeleteWithContents->True,
       Editable->False,
       SelectWithContents->True,
       Selectable->False,
       StripWrapperBoxes->True]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.8737142826259403`*^9, 3.873714303154018*^9}, {
   3.873714354482944*^9, 3.87371439171515*^9}, {3.873714422598215*^9, 
   3.873714423029265*^9}, {3.8737148652782393`*^9, 3.8737149106333227`*^9}, {
   3.87371526248965*^9, 3.873715449153006*^9}, {3.873784580325987*^9, 
   3.873784611498169*^9}, {3.873788131335578*^9, 3.8737882607627153`*^9}, 
   3.873788627504628*^9, {3.873791359248292*^9, 3.87379141831439*^9}, {
   3.873791665713743*^9, 3.8737916773737*^9}, {3.873791938914509*^9, 
   3.873791946534399*^9}, {3.873791980952738*^9, 3.873791982304152*^9}, {
   3.873798368440868*^9, 
   3.8737983712944517`*^9}},ExpressionUUID->"ac7e22cb-9171-4cc5-bae4-\
26675be772d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadRadialFunctionsScalarRelativistic", "[", "FileNames_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "position", ",", "BasisFun", ",", "Orbitals", ",", "BasisRawVal1", ",", 
      "BasisRawVal2", ",", "BasisRawVal3", ",", "BasisRawVal4", ",", 
      "BasisVal1", ",", "BasisVal2", ",", "BasisVal3", ",", "BasisVal4", ",", 
      "BasisVal1Fun", ",", "BasisVal2Fun", ",", "BasisVal3Fun", ",", 
      "BasisVal4Fun", ",", "OrbitalsRawVal1", ",", "OrbitalsRawVal2", ",", 
      "OrbitalsRawVal3", ",", "OrbitalsRawVal4", ",", "\[IndentingNewLine]", 
      "spos", ",", "ppos", ",", "dpos", ",", "fpos", ",", "gpos"}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"BasisRawVal1", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "filename", "<>", 
             "\"\<.1\>\""}], ",", "\"\<Table\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"filename", ",", "FileNames"}], "}"}]}], "]"}], ",", "1"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BasisRawVal2", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "filename", "<>", 
             "\"\<.2\>\""}], ",", "\"\<Table\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"filename", ",", "FileNames"}], "}"}]}], "]"}], ",", "1"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BasisRawVal3", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "filename", "<>", 
             "\"\<.3\>\""}], ",", "\"\<Table\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"filename", ",", "FileNames"}], "}"}]}], "]"}], ",", "1"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BasisRawVal4", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "filename", "<>", 
             "\"\<.4\>\""}], ",", "\"\<Table\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"filename", ",", "FileNames"}], "}"}]}], "]"}], ",", "1"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BasisVal1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BasisRawVal1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ";;", 
           RowBox[{"i", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<<start\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "+", 
              "1"}], ",", 
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<<end\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "-", 
              "1"}]}], "}"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal2", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BasisRawVal2", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ";;", 
           RowBox[{"i", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<<start\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "+", 
              "1"}], ",", 
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<<end\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal2", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "-", 
              "1"}]}], "}"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal3", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BasisRawVal3", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ";;", 
           RowBox[{"i", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal3", ",", "\"\<<start\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal3", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "+", 
              "1"}], ",", 
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal3", ",", "\"\<<end\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal3", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "-", 
              "1"}]}], "}"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal4", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BasisRawVal4", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ";;", 
           RowBox[{"i", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal4", ",", "\"\<<start\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal4", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "+", 
              "1"}], ",", 
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal4", ",", "\"\<<end\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal4", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "-", 
              "1"}]}], "}"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal1Fun", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<Spline\>\""}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "BasisVal1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal2Fun", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<Spline\>\""}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "BasisVal2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal3Fun", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<Spline\>\""}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "BasisVal3"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal4Fun", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<Spline\>\""}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "BasisVal4"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisFun", "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
        "BasisVal1Fun", ",", "BasisVal2Fun", ",", "BasisVal3Fun", ",", 
         "BasisVal4Fun"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"OrbitalsRawVal1", "=", 
      RowBox[{"NiceOrbScalarRelativistic", "[", 
       RowBox[{
        RowBox[{"BasisRawVal1", "[", 
         RowBox[{"[", 
          RowBox[{"Intersection", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal1", ",", "\"\<<start\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "]"}], 
         "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{
           RowBox[{"-", "1"}], ";;", 
           RowBox[{"-", "1"}]}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"OrbitalsRawVal2", "=", 
      RowBox[{"NiceOrbScalarRelativistic", "[", 
       RowBox[{
        RowBox[{"BasisRawVal2", "[", 
         RowBox[{"[", 
          RowBox[{"Intersection", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal2", ",", "\"\<<start\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal2", ",", "\"\<function\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "]"}], 
         "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{
           RowBox[{"-", "1"}], ";;", 
           RowBox[{"-", "1"}]}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"OrbitalsRawVal3", "=", 
      RowBox[{"NiceOrbScalarRelativistic", "[", 
       RowBox[{
        RowBox[{"BasisRawVal3", "[", 
         RowBox[{"[", 
          RowBox[{"Intersection", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal3", ",", "\"\<<start\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal3", ",", "\"\<function\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "]"}], 
         "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{
           RowBox[{"-", "1"}], ";;", 
           RowBox[{"-", "1"}]}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"OrbitalsRawVal4", "=", 
      RowBox[{"NiceOrbScalarRelativistic", "[", 
       RowBox[{
        RowBox[{"BasisRawVal4", "[", 
         RowBox[{"[", 
          RowBox[{"Intersection", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal4", ",", "\"\<<start\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal4", ",", "\"\<function\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "]"}], 
         "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{
           RowBox[{"-", "1"}], ";;", 
           RowBox[{"-", "1"}]}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Orbitals", "=", "OrbitalsRawVal1"}], ";", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{"spos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<s\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<s\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ppos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"dpos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"fpos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"gpos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"position", "[", "OrbitalName_", "]"}], ":=", 
      TagBox[GridBox[{
         {"\[Piecewise]", GridBox[{
            {"spos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<s\>\""}]},
            {"ppos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<p\>\""}]},
            {"dpos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<d\>\""}]},
            {"fpos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<f\>\""}]},
            {"gpos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<g\>\""}]}
           },
           AllowedDimensions->{2, Automatic},
           Editable->True,
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.84]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           Selectable->True]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.35]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Piecewise",
       DeleteWithContents->True,
       Editable->False,
       SelectWithContents->True,
       Selectable->False,
       StripWrapperBoxes->True]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.8737871572801123`*^9, 3.873787161669941*^9}, {
  3.873788618596592*^9, 3.8737886581307487`*^9}, {3.8737899516836157`*^9, 
  3.8737899626172028`*^9}, {3.8737914943121634`*^9, 3.8737915478154287`*^9}, {
  3.873791692665881*^9, 3.8737917119155827`*^9}, {3.873791868897563*^9, 
  3.873791921188921*^9}, {3.873798538262192*^9, 
  3.873798538762188*^9}},ExpressionUUID->"03cb0772-c1ac-4cd7-b6fb-\
dc9b824c7e42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadRadialFunctionsNonRelativistic", "[", "FileNames_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "position", ",", "BasisFun", ",", "Orbitals", ",", "BasisRawVal1", ",", 
      "BasisVal1", ",", "BasisVal1Fun", ",", "OrbitalsRawVal1", ",", 
      "\[IndentingNewLine]", "spos", ",", "ppos", ",", "dpos", ",", "fpos", 
      ",", "gpos"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"BasisRawVal1", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Import", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "filename", "<>", 
             "\"\<.1\>\""}], ",", "\"\<Table\>\""}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"filename", ",", "FileNames"}], "}"}]}], "]"}], ",", "1"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"BasisVal1", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BasisRawVal1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ";;", 
           RowBox[{"i", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<<start\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "+", 
              "1"}], ",", 
             RowBox[{
              RowBox[{"Intersection", "[", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<<end\>\""}], "]"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"Position", "[", 
                  RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], 
                 "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "-", 
              "1"}]}], "}"}], "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisVal1Fun", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Interpolation", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<Spline\>\""}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "BasisVal1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"BasisFun", "=", "BasisVal1Fun"}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"OrbitalsRawVal1", "=", 
      RowBox[{"NiceOrbScalarRelativistic", "[", 
       RowBox[{
        RowBox[{"BasisRawVal1", "[", 
         RowBox[{"[", 
          RowBox[{"Intersection", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal1", ",", "\"\<<start\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{"BasisRawVal1", ",", "\"\<function\>\""}], "]"}], "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}], " ", "]"}], "]"}], 
         "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", 
          RowBox[{
           RowBox[{"-", "1"}], ";;", 
           RowBox[{"-", "1"}]}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Orbitals", "=", "OrbitalsRawVal1"}], ";", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{"spos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<s\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<s\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ppos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<p\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"dpos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<d\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"fpos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<f\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"gpos", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "1"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g\>\""}], "]"}], ",", 
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"StringDrop", "[", 
               RowBox[{"a", ",", "2"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "Orbitals"}], "}"}]}], "]"}], ",", 
            "\"\<g\>\""}], "]"}]}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"position", "[", "OrbitalName_", "]"}], ":=", 
      TagBox[GridBox[{
         {"\[Piecewise]", GridBox[{
            {"spos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<s\>\""}]},
            {"ppos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<p\>\""}]},
            {"dpos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<d\>\""}]},
            {"fpos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<f\>\""}]},
            {"gpos", 
             RowBox[{"OrbitalName", "\[Equal]", "\"\<g\>\""}]}
           },
           AllowedDimensions->{2, Automatic},
           Editable->True,
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           
           GridBoxItemSize->{
            "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{1.}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.84]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}},
           Selectable->True]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.35]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Piecewise",
       DeleteWithContents->True,
       Editable->False,
       SelectWithContents->True,
       Selectable->False,
       StripWrapperBoxes->True]}], ";", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.8737871572801123`*^9, 3.873787161669941*^9}, {
   3.873788618596592*^9, 3.8737886581307487`*^9}, {3.8737899516836157`*^9, 
   3.8737899626172028`*^9}, {3.8737914943121634`*^9, 
   3.8737915478154287`*^9}, {3.873791692665881*^9, 3.8737917119155827`*^9}, {
   3.873791868897563*^9, 3.873791921188921*^9}, {3.873798466826404*^9, 
   3.873798467111507*^9}, {3.873798502727426*^9, 3.873798534588149*^9}, 
   3.8737986070998383`*^9},ExpressionUUID->"89102124-27b2-4451-af24-\
16b6b17b7183"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculate the overlap between all radial functions", "Subsection",
 CellChangeTimes->{{3.8737992271165648`*^9, 
  3.873799274974471*^9}},ExpressionUUID->"765a2813-fe55-4a37-9cd1-\
ed48aa3006ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "CalculateOverlapRadialFunctionsNonRelativistic", "[", "ReadOutput_", "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], "=", 
      "ReadOutput"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<\\n=================================\>\"", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Orbital is \>\"", "<>", "OrbitalNow"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", "\"\<=================================\>\"", "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"NIntegrate", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"BasisFun", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", "r", "]"}], " ", 
                RowBox[{
                 RowBox[{"BasisFun", "[", 
                  RowBox[{"[", "j", "]"}], "]"}], "[", "r", "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
               RowBox[{"AccuracyGoal", "\[Rule]", "12"}], ",", 
               RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
               RowBox[{"MinRecursion", "\[Rule]", "5"}], ",", 
               RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", 
               RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], "]"}],
            ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"OrbitalNow", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<s\>\"", ",", "\"\<p\>\"", ",", "\"\<d\>\"", ",", "\"\<f\>\""}],
           "}"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.873798588707037*^9, 3.8737985890010643`*^9}, {
  3.873798639713512*^9, 
  3.873798648357093*^9}},ExpressionUUID->"b0359a24-40f0-48cb-b90b-\
50ab6f2a77e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "CalculateOverlapRadialFunctionsScalarRelativistic", "[", "ReadOutput_", 
   "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], "=", 
      "ReadOutput"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<\\n=================================\>\"", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Orbital is \>\"", "<>", "OrbitalNow"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", "\"\<=================================\>\"", "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"g", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"NIntegrate", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "[", "r", "]"}], 
                 " ", 
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1"}], "]"}], "]"}], "[", "r", "]"}]}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
                RowBox[{"AccuracyGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"MinRecursion", "\[Rule]", "5"}], ",", 
                RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], 
             "]"}]}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"f", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"NIntegrate", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", "r", "]"}], 
                 " ", 
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], "[", "r", "]"}]}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
                RowBox[{"AccuracyGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"MinRecursion", "\[Rule]", "5"}], ",", 
                RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], 
             "]"}]}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"gm", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"NIntegrate", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], "[", "r", "]"}], 
                 " ", 
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "3"}], "]"}], "]"}], "[", "r", "]"}]}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
                RowBox[{"AccuracyGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"MinRecursion", "\[Rule]", "5"}], ",", 
                RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], 
             "]"}]}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"fm", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"NIntegrate", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "4"}], "]"}], "]"}], "[", "r", "]"}], 
                 " ", 
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "4"}], "]"}], "]"}], "[", "r", "]"}]}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
                RowBox[{"AccuracyGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"MinRecursion", "\[Rule]", "5"}], ",", 
                RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], 
             "]"}]}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"Chop", "[", 
            RowBox[{
             RowBox[{"g", "+", "f", "+", "gm", "+", "fm"}], ",", 
             SuperscriptBox["10", 
              RowBox[{"-", "9"}]]}], "]"}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"OrbitalNow", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<s\>\"", ",", "\"\<p\>\"", ",", "\"\<d\>\"", ",", "\"\<f\>\""}],
           "}"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.873714602862165*^9, 3.8737146125645*^9}, {
   3.873715471095786*^9, 3.873715521057805*^9}, {3.8737155515293293`*^9, 
   3.873715575272184*^9}, {3.8737157102356358`*^9, 3.873715737831365*^9}, {
   3.8737244290895967`*^9, 3.87372444862036*^9}, {3.873787309325839*^9, 
   3.873787340426593*^9}, {3.8737929066427803`*^9, 3.873792982272893*^9}, {
   3.873793568322806*^9, 3.873793571097233*^9}, 
   3.873798662323173*^9},ExpressionUUID->"00dc0471-c482-4443-98dc-\
56c7f180131c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "CalculateOverlapRadialFunctionsRelativistic", "[", "ReadOutput_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], "=", 
      "ReadOutput"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
        "Print", "[", "\"\<\\n=================================\>\"", "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Orbital is \>\"", "<>", "OrbitalNow"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", "\"\<=================================\>\"", "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"g", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"NIntegrate", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "[", "r", "]"}], 
                 " ", 
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "1"}], "]"}], "]"}], "[", "r", "]"}]}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
                RowBox[{"AccuracyGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"MinRecursion", "\[Rule]", "5"}], ",", 
                RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], 
             "]"}]}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"f", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"NIntegrate", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", "r", "]"}], 
                 " ", 
                 RowBox[{
                  RowBox[{"BasisFun", "[", 
                   RowBox[{"[", 
                    RowBox[{"j", ",", "2"}], "]"}], "]"}], "[", "r", "]"}]}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
                RowBox[{"AccuracyGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"PrecisionGoal", "\[Rule]", "12"}], ",", 
                RowBox[{"MinRecursion", "\[Rule]", "5"}], ",", 
                RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", 
                RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], 
             "]"}]}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"TableForm", "[", 
          RowBox[{
           RowBox[{"Chop", "[", 
            RowBox[{
             RowBox[{"g", "+", "f"}], ",", 
             SuperscriptBox["10", 
              RowBox[{"-", "9"}]]}], "]"}], ",", 
           RowBox[{"TableHeadings", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}], 
              ",", 
              RowBox[{"Orbitals", "[", 
               RowBox[{"[", 
                RowBox[{"position", "[", "OrbitalNow", "]"}], "]"}], "]"}]}], 
             "}"}]}]}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"OrbitalNow", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<s12\>\"", ",", "\"\<p12\>\"", ",", "\"\<p32\>\"", ",", 
           "\"\<d32\>\"", ",", "\"\<d52\>\"", ",", "\"\<f52\>\"", ",", 
           "\"\<f72\>\""}], "}"}]}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.873793572748207*^9, 3.8737935735970163`*^9}, 
   3.873798383007325*^9},ExpressionUUID->"810dff2d-0ef2-4796-8adf-\
109002297c47"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot the functions", "Subsection",
 CellChangeTimes->{{3.8737992271165648`*^9, 
  3.873799282369073*^9}},ExpressionUUID->"d34779a5-af51-408a-94c8-\
35b8c6469ee5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotRadialFunctionsRelativistic", "[", "ReadOutput_", "]"}], ":=", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], "=", 
      "ReadOutput"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"BasisFun", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], "[", "r", "]"}], ",", 
             RowBox[{
              RowBox[{"BasisFun", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", "r", "]"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"OrbitalNow", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<s12\>\"", ",", "\"\<p12\>\"", ",", "\"\<p32\>\"", ",", 
           "\"\<d32\>\"", ",", "\"\<d52\>\"", ",", "\"\<f52\>\"", ",", 
           "\"\<f72\>\""}], "}"}]}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.873724320948048*^9, 3.873724353523219*^9}, {
   3.87372439509588*^9, 3.873724419075614*^9}, {3.873724460030949*^9, 
   3.8737245487580013`*^9}, 
   3.873798388728176*^9},ExpressionUUID->"0e81500d-65ce-47f3-a9c6-\
df41d42f2d76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotRadialFunctionsScalarRelativistic", "[", "ReadOutput_", "]"}], 
  ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], "=", 
      "ReadOutput"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"BasisFun", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], "[", "r", "]"}], ",", 
             RowBox[{
              RowBox[{"BasisFun", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}], "[", "r", "]"}], ",", 
             RowBox[{
              RowBox[{"BasisFun", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "3"}], "]"}], "]"}], "[", "r", "]"}], ",", 
             RowBox[{
              RowBox[{"BasisFun", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "4"}], "]"}], "]"}], "[", "r", "]"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"OrbitalNow", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<s\>\"", ",", "\"\<p\>\"", ",", "\"\<d\>\"", ",", "\"\<f\>\""}],
           "}"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.873792118065584*^9, 3.8737921383704777`*^9}, {
  3.873792172294783*^9, 3.87379218117372*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"aca9a001-c1aa-4284-913e-c0fb29418691"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotRadialFunctionsNonRelativistic", "[", "ReadOutput_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"BasisFun", ",", "Orbitals", ",", "position"}], "}"}], "=", 
      "ReadOutput"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"BasisFun", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", "r", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", "0", ",", "30"}], "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"position", "[", "OrbitalNow", "]"}]}], "}"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"OrbitalNow", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<s\>\"", ",", "\"\<p\>\"", ",", "\"\<d\>\"", ",", "\"\<f\>\""}],
           "}"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.87379868249226*^9, 
  3.8737986966838217`*^9}},ExpressionUUID->"5b63722b-598e-48f7-9e1b-\
fd88d4e04eed"]
}, Open  ]]
},
WindowSize->{2471, 1479},
WindowMargins->{{1496, Automatic}, {Automatic, 9}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"164c9617-0535-450c-a561-ccbb69fd0d40"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 234, 6, 35, "Text",ExpressionUUID->"34455bfe-e148-4032-a329-18cf78fb01bd"],
Cell[795, 28, 3025, 93, 197, "Text",ExpressionUUID->"2ee9fdac-d463-494f-b81b-6c65a4093c3e"],
Cell[CellGroupData[{
Cell[3845, 125, 177, 3, 54, "Subsection",ExpressionUUID->"74fa43d3-9693-417e-9a63-c1496757a66b"],
Cell[4025, 130, 862, 26, 30, "Input",ExpressionUUID->"e1abcb9a-a6d7-40f5-92d5-1ef5a78edebd"],
Cell[4890, 158, 435, 12, 30, "Input",ExpressionUUID->"1728a30a-20be-4403-8117-2760f512e72d"],
Cell[5328, 172, 486, 14, 30, "Input",ExpressionUUID->"80378ee1-26f2-4cf3-8186-3e4df9788747"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5851, 191, 176, 3, 54, "Subsection",ExpressionUUID->"6b22a6eb-2ae6-4b01-946e-89e9b0483a80"],
Cell[6030, 196, 22764, 580, 823, "Input",ExpressionUUID->"ac7e22cb-9171-4cc5-bae4-26675be772d4"],
Cell[28797, 778, 22844, 581, 803, "Input",ExpressionUUID->"03cb0772-c1ac-4cd7-b6fb-dc9b824c7e42"],
Cell[51644, 1361, 11556, 294, 551, "Input",ExpressionUUID->"89102124-27b2-4451-af24-16b6b17b7183"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63237, 1660, 200, 3, 54, "Subsection",ExpressionUUID->"765a2813-fe55-4a37-9cd1-ed48aa3006ae"],
Cell[63440, 1665, 3000, 75, 178, "Input",ExpressionUUID->"b0359a24-40f0-48cb-b90b-50ab6f2a77e5"],
Cell[66443, 1742, 9715, 232, 272, "Input",ExpressionUUID->"00dc0471-c482-4443-98dc-56c7f180131c"],
Cell[76161, 1976, 5785, 141, 230, "Input",ExpressionUUID->"810dff2d-0ef2-4796-8adf-109002297c47"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81983, 2122, 168, 3, 54, "Subsection",ExpressionUUID->"d34779a5-af51-408a-94c8-35b8c6469ee5"],
Cell[82154, 2127, 1973, 51, 136, "Input",ExpressionUUID->"0e81500d-65ce-47f3-a9c6-df41d42f2d76"],
Cell[84130, 2180, 2180, 56, 136, "Input",ExpressionUUID->"aca9a001-c1aa-4284-913e-c0fb29418691"],
Cell[86313, 2238, 1489, 39, 136, "Input",ExpressionUUID->"5b63722b-598e-48f7-9e1b-fd88d4e04eed"]
}, Open  ]]
}
]
*)

